using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents logout request 
	/// message defined in VistALink protocol. 
	/// </summary>
	public sealed class SecurityLogoutRequestMessage : SecuritySimpleRequestMessage
	{		
		/// <summary>
		/// VistALink message request type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string RequestType = "AV.Logout";

		/// <summary>
		/// Default constructor - the message does not require any parameters. 
		/// </summary>
		public SecurityLogoutRequestMessage() 
			: base( RequestType ){}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		public SecurityLogoutRequestMessage( XmlDocument sourceDoc ) 
			: base( RequestType, sourceDoc ) {}
	}
}
